package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.CustomerDataI;
import com.avaya.ccs.api.DestinationListI;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.ResponseData;
import com.avaya.ccs.api.enums.DestinationListType;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.core.CustomerData;
import com.avaya.ccs.core.CustomerHistory;
import com.avaya.ccs.core.CustomerList;

import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;

public class CustomerEventTask extends Task<Object> {

	private final NotificationEventI<CustomerDataI> customerEvent;
    private final InteractionDataGUI gui;
   
    private static final Logger LOG = Logger.getLogger(CustomerEventTask.class);
    
    CustomerExecutor customerExecutor;
	
	public CustomerEventTask(NotificationEventI<CustomerDataI> customerEvent, InteractionDataGUI gui, 
			CustomerExecutor customerExecutor) {
		this.customerEvent =customerEvent;
		this.gui=gui;
		this.customerExecutor=customerExecutor;
		
		setupJavaFXApplicationSucceededHandler();
		
		
	}
	
	
	private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded((WorkerStateEvent t) -> {
//			TODO conroy1 add in a future release
//            String methodName = "succeededHandler() ";
//            Customer value = (Customer)t.getSource().getValue();
//            if (value == null) {
//                LOG.debug(methodName + "NULL");
//            } 
//            else {
//                CustomerSearchTab customerSearchTab = gui.getSideBar().getCustomerSearchTab();
//                customerSearchTab.setSearchResults(value);
//	        }
        });
    }
	
	
	
	@Override
	protected Object call() throws Exception {
		String methodName = "call() ";
		
		NotificationType type = customerEvent.getNotificationType();
		
		LOG.debug(methodName + "Type:" + type);
		
		switch (type) {
        case UPDATE:
        case DELETE:
        case ERROR:
        case NEW:
        	LOG.warn(methodName, " no implemented");
        break;
        case RESPONSE:
//	        ResponseData resp = customerEvent.getResponseData();
	        CustomerDataI c = customerEvent.getNotificationObject();
	        LOG.info(methodName + " returning response data: " + c);
	        
	        return c;
    case UNKNOWN:
    	 LOG.warn(methodName + " unknown ");
        break;
    }
		
//        InteractionData data = null;
//       
//        NotificationType type = interactionEvent.getNotificationType();
//        LOG.debug(methodName + "Type:" + type + " ID:" + interactionEvent.getNotificationObject().getId());
//
//        switch (type) {
//	        case UPDATE:
//	            data = new InteractionData(interactionEvent.getNotificationObject());
//	            switch (data.getState()) {
//		            case Wrapup:
//		                if (data.getWrapupTimer() >= 0) {
//		                    LOG.debug(methodName + " create wrapup timer if not already running");
//		                    InteractionExecutor.getTimers().startWrapUp(data.getWrapupTimer(), data.getId(), this.gui);
//		                    data.setTimeLeft(data.getWrapupTimer());
//		                }
//		                break;
//		            case Active:
//		            	if (interactionEvent.getNotificationObject().isMultimedia()) {
//		            		//open the multimedia stream
//		            		interactionExecutor.openInteractionMedia(interactionEvent.getNotificationObject().getId());
//		            		break;
//		            	}
//
//	            case Dialing:
//	            case Dropped:
//	            case Held:
//	            case Pending:
//	            case Ringing:
//	            case Unknown:
//	            default:
//	                InteractionExecutor.getTimers().stop(interactionEvent.getNotificationObject().getId());
//	                break;
//	            }
//            break;
//        case DELETE:
//            data = new InteractionData(interactionEvent.getNotificationObject().getId(), true);
//            InteractionExecutor.getTimers().stop(interactionEvent.getNotificationObject().getId());
//            break;
//        case ERROR:
//            LOG.errorStatus(interactionEvent.getError());
//            break;
//        case NEW:
//            data = new InteractionData(interactionEvent.getNotificationObject());
//            switch (data.getState()) {
//            case Preview:
//                if (data.getPreviewTimer() >= 0) {
//                    LOG.debug(methodName + "New interaction in preview state, start preview timer");
//                    InteractionExecutor.getTimers().startPreview(data.getPreviewTimer(), data.getId(),
//                            data.getDefaultOrFirstContactNumber(), this.gui);
//                    data.setTimeLeft(data.getPreviewTimer());
//                }
//                break;
//            default:
//                break;
//            }
//            break;
//        case RESPONSE:
//            ResponseData resp = interactionEvent.getResponseData();
//            return resp;
//        case UNKNOWN:
//            break;
//        }
//        return data;
		return null;
	}
	
	


//	    public InteractionEventTask(NotificationEventI<InteractionI> interactionEvent, InteractionDataGUI gui,
//	            SupervisorDataGUI gui2, InteractionExecutor interactionExecutor) {
//	    	this.interactionEvent = interactionEvent;
//	        this.gui = gui;
//	        this.superGui = gui2;
//	        this.interactionExecutor=interactionExecutor;
//	        setupJavaFXApplicationSucceededHandler();
//	    }
//
//	    private void setupJavaFXApplicationSucceededHandler() {
//	        this.setOnSucceeded((WorkerStateEvent t) -> {
//	            String methodName = "succeededHandler() ";
//	            Object value = t.getSource().getValue();
//	            if (value == null) {
//	                LOG.debug(methodName + "NULL");
//	            } 
//	            else if (value instanceof InteractionData) {
//	                InteractionData newData = (InteractionData) value;
//	                if (!newData.isDeleted())
//	                    LOG.info(methodName + "InteractionData:" + newData);
//	                else
//	                    LOG.info(methodName + "Deletion of InteractionData-ID:" + newData.getId());
//	                gui.UpdateInteractionData(newData);
//	                superGui.updateInteraction(newData);
//	            } else if (value instanceof CodeListI) {
//	                CodeListI codes = (CodeListI) value;
//	                LOG.info(methodName + "CodeListI:" + codes);
//	                gui.updateCodeSectionForm(codes);
//	            } else if (value instanceof DestinationListI) {
//	                DestinationListI destinations = (DestinationListI) value;
//	                LOG.info(methodName + "DestinationListI:" + destinations);
//	                if (destinations.getListType() == DestinationListType.Consult) {
//	                    gui.getConsultForm().updateDestinationList(interactionEvent.getNotificationObject().getId(),
//	                            destinations);
//	                    gui.getEmailFormForContact(interactionEvent.getNotificationObject().getId()).getConsultForm().updateDestinationList(interactionEvent.getNotificationObject().getId(),
//	                            destinations); 
//	                    
//	                } else if (destinations.getListType() == DestinationListType.Callback) {
//	                    gui.getCallbackForm().updateDestinationList(interactionEvent.getNotificationObject().getId(),
//	                            destinations);
//	                }
//	            } else if (value instanceof CustomerHistory ) {
//	            	gui.getEmailFormForContact(interactionEvent.getNotificationObject().getId()).updateForm(); 
//		        }
//	        });
//	    }
//
//	    /**
//	     * The call method executes on the incomingEvent thread
//	     *
//	     * @return
//	     * @throws Exception
//	     */
//	    @Override
//	    protected Object call() throws Exception {
//	        String methodName = "call() ";
//	        InteractionData data = null;
//	       
//	        NotificationType type = interactionEvent.getNotificationType();
//	        LOG.debug(methodName + "Type:" + type + " ID:" + interactionEvent.getNotificationObject().getId());
//
//	        switch (type) {
//		        case UPDATE:
//		            data = new InteractionData(interactionEvent.getNotificationObject());
//		            switch (data.getState()) {
//			            case Wrapup:
//			                if (data.getWrapupTimer() >= 0) {
//			                    LOG.debug(methodName + " create wrapup timer if not already running");
//			                    InteractionExecutor.getTimers().startWrapUp(data.getWrapupTimer(), data.getId(), this.gui);
//			                    data.setTimeLeft(data.getWrapupTimer());
//			                }
//			                break;
//			            case Active:
//			            	if (interactionEvent.getNotificationObject().isMultimedia()) {
//			            		//open the multimedia stream
//			            		interactionExecutor.openInteractionMedia(interactionEvent.getNotificationObject().getId());
//			            		break;
//			            	}
//
//		            case Dialing:
//		            case Dropped:
//		            case Held:
//		            case Pending:
//		            case Ringing:
//		            case Unknown:
//		            default:
//		                InteractionExecutor.getTimers().stop(interactionEvent.getNotificationObject().getId());
//		                break;
//		            }
//	            break;
//	        case DELETE:
//	            data = new InteractionData(interactionEvent.getNotificationObject().getId(), true);
//	            InteractionExecutor.getTimers().stop(interactionEvent.getNotificationObject().getId());
//	            break;
//	        case ERROR:
//	            LOG.errorStatus(interactionEvent.getError());
//	            break;
//	        case NEW:
//	            data = new InteractionData(interactionEvent.getNotificationObject());
//	            switch (data.getState()) {
//	            case Preview:
//	                if (data.getPreviewTimer() >= 0) {
//	                    LOG.debug(methodName + "New interaction in preview state, start preview timer");
//	                    InteractionExecutor.getTimers().startPreview(data.getPreviewTimer(), data.getId(),
//	                            data.getDefaultOrFirstContactNumber(), this.gui);
//	                    data.setTimeLeft(data.getPreviewTimer());
//	                }
//	                break;
//	            default:
//	                break;
//	            }
//	            break;
//	        case RESPONSE:
//	            ResponseData resp = interactionEvent.getResponseData();
//	            return resp;
//	        case UNKNOWN:
//	            break;
//	        }
//	        return data;
//	    }

}
